#import "ScrollWheel.h"

#pragma mark Operacje matematyczne
// Zwrot punktu w odniesieniu do danego punktu początkowego.
CGPoint centeredPoint(CGPoint pt, CGPoint origin)
{
	return CGPointMake(pt.x - origin.x, pt.y - origin.y);
}

// Zwrot kąta punktu w odniesieniu do danego punktu początkowego.
float getangle (CGPoint p1, CGPoint c1)
{
	// SOH CAH TOA.
	CGPoint p = centeredPoint(p1, c1);
	float h = ABS(sqrt(p.x * p.x + p.y * p.y));
	float a = p.x;
	float baseAngle = acos(a/h) * 180.0f / M_PI;
	
	// Powyżej 180
	if (p1.y > c1.y) baseAngle = 360.0f - baseAngle;
	
	return baseAngle;
}

// zwrot punktu znajdującego się w promieniu od danego punktu początkowego.
BOOL pointInsideRadius(CGPoint p1, float r, CGPoint c1)
{
	CGPoint pt = centeredPoint(p1, c1);
	float xsquared = pt.x * pt.x;
	float ysquared = pt.y * pt.y;
	float h = ABS(sqrt(xsquared + ysquared));
	if (((xsquared + ysquared) / h) < r) return YES;
	return NO;
}

@implementation ScrollWheel
@synthesize value;
@synthesize theta;

#pragma mark Inicjalizacja obiektu
- (id) initWithFrame: (CGRect) aFrame
{
	if (self = [super initWithFrame:aFrame])
	{
		// Kontrolka używa ramki o stałej wielkości 200×200 punktów.
		self.frame = CGRectMake(0.0f, 0.0f, 200.0f, 200.0f); 
		self.center = CGPointMake(CGRectGetMidX(aFrame), CGRectGetMidY(aFrame));
		
		// Dodanie grafiki tarczy.
		UIImageView *iv = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"wheel.png"]];
		[self  addSubview:iv];
	}
	
	return self;
}

- (id) init
{
	return [self initWithFrame:CGRectZero];
}

+ (id) scrollWheel
{
	return [[self alloc] init];
}

#pragma mark Śledzenie dotknięć

- (BOOL)beginTrackingWithTouch:(UITouch *)touch withEvent:(UIEvent *)event
{
	CGPoint p = [touch locationInView:self];
	CGPoint cp = CGPointMake(self.bounds.size.width / 2.0f, self.bounds.size.height / 2.0f);
	// self.value = 0.0f; // Usuń znak komentarza, aby każde dotknięcie otrzymało oddzielną wartość.
	
	// Pierwsze dotknięcie musi być w obrębie szarej części tarczy.
	if (!pointInsideRadius(p, cp.x, cp)) return NO;
	if (pointInsideRadius(p, 30.0f, cp)) return NO;

	// Ustawienie kąta początkowego.
	self.theta = getangle([touch locationInView:self], cp);

	// Zdarzenie naciśnięcia kontrolki.
	[self sendActionsForControlEvents:UIControlEventTouchDown];

	return YES;
}

- (BOOL)continueTrackingWithTouch:(UITouch *)touch withEvent:(UIEvent *)event
{
	
	CGPoint p = [touch locationInView:self];
	CGPoint cp = CGPointMake(self.bounds.size.width / 2.0f, self.bounds.size.height / 2.0f);
	
	// Uaktualnienie dotyku.
	if (CGRectContainsPoint(self.frame, p))
        [self sendActionsForControlEvents:UIControlEventTouchDragInside];
    else 
        [self sendActionsForControlEvents:UIControlEventTouchDragOutside];		

	// Zbyt daleko na zewnątrz, powyżej granicy 50 pikseli.
	if (!pointInsideRadius(p, cp.x + 50.0f, cp)) return NO;
	
	float newtheta = getangle([touch locationInView:self], cp);
	float dtheta = newtheta - self.theta;

	// Odpowiednie dla warunków brzegowych.
	int ntimes = 0;
	while ((ABS(dtheta) > 300.0f)  && (ntimes++ < 4))
		if (dtheta > 0.0f) dtheta -= 360.0f; else dtheta += 360.0f;

	// Uaktualnienie wartości bieżących.
	self.value -= dtheta / 360.0f;
	self.theta = newtheta;

	// Wysłanie wiadomości informującej o zmianie wartości.
	[self sendActionsForControlEvents:UIControlEventValueChanged];

	return YES;
}

- (void) endTrackingWithTouch: (UITouch *)touch withEvent: (UIEvent *)event
{
    // Sprawdzenie, czy miejsce zakończenie dotknięcia znajduje się w kontrolce, czy poza nią.
    CGPoint touchPoint = [touch locationInView:self];
    if (CGRectContainsPoint(self.bounds, touchPoint))
        [self sendActionsForControlEvents:UIControlEventTouchUpInside];
    else 
        [self sendActionsForControlEvents:UIControlEventTouchUpOutside];
}


- (void)cancelTrackingWithEvent: (UIEvent *) event
{
	// Anulowanie.
	[self sendActionsForControlEvents:UIControlEventTouchCancel];
}
@end
